#ifndef _BOARD_CONFIG_H_
#define _BOARD_CONFIG_H_

#include <driver/gpio.h>

#define AUDIO_INPUT_REFERENCE       true

#define AUDIO_INPUT_SAMPLE_RATE     24000
#define AUDIO_OUTPUT_SAMPLE_RATE    24000
#define AUDIO_DEFAULT_OUTPUT_VOLUME 70

#define AUDIO_I2S_GPIO_MCLK GPIO_NUM_14
#define AUDIO_I2S_GPIO_BCLK GPIO_NUM_13
#define AUDIO_I2S_GPIO_WS   GPIO_NUM_11
#define AUDIO_I2S_GPIO_DOUT GPIO_NUM_12
#define AUDIO_I2S_GPIO_DIN  GPIO_NUM_10

#define AUDIO_CODEC_PA_PIN       GPIO_NUM_17
#define AUDIO_CODEC_I2C_SCL_PIN  GPIO_NUM_21
#define AUDIO_CODEC_I2C_SDA_PIN  GPIO_NUM_18
#define AUDIO_CODEC_ES8388_ADDR ES8388_CODEC_DEFAULT_ADDR

#define BOOT_BUTTON_PIN         GPIO_NUM_2
#define BOOT_5V_PIN             GPIO_NUM_3      //5V升压输出
#define BOOT_4G_PIN             GPIO_NUM_5      //4G模块使能
#define MON_BATT_PIN            GPIO_NUM_43    	//检测PMU电池指示
#define MON_BATT_CNT            70    	        //检测PMU电池秒数
#define MON_USB_PIN				GPIO_NUM_47    	//检测USB插入


#define ML307_RX_PIN            GPIO_NUM_16
#define ML307_TX_PIN            GPIO_NUM_15

#define DISPLAY_SPI_LCD_HOST    SPI2_HOST
#define DISPLAY_SPI_CLOCK_HZ    (40 * 1000 * 1000)
#define DISPLAY_SPI_PIN_SCLK    42
#define DISPLAY_SPI_PIN_MOSI    40
#define DISPLAY_SPI_PIN_MISO    -1
#define DISPLAY_SPI_PIN_LCD_DC  41
#define DISPLAY_SPI_PIN_LCD_RST 45
#define DISPLAY_SPI_PIN_LCD_CS  -1
#define DISPLAY_PIN_TOUCH_CS    -1

#define DISPLAY_BACKLIGHT_PIN   GPIO_NUM_46
#define DISPLAY_BACKLIGHT_OUTPUT_INVERT false

#define DISPLAY_WIDTH   320
#define DISPLAY_HEIGHT  240
#define DISPLAY_SWAP_XY true
#define DISPLAY_MIRROR_X false
#define DISPLAY_MIRROR_Y true
#define DISPLAY_INVERT_COLOR false
#define DISPLAY_RGB_ORDER_COLOR LCD_RGB_ELEMENT_ORDER_RGB

#define DISPLAY_OFFSET_X  0
#define DISPLAY_OFFSET_Y  0
#define KEY_EXPIRE_MS   800

#endif // _BOARD_CONFIG_H_
