#ifndef FONT_AWESOME_H
#define FONT_AWESOME_H

#include <stdint.h>
#include <stddef.h>
#include <string.h>

// 符号结构体
typedef struct {
    const char* name;
    const char* utf8_string;
} font_awesome_symbol_t;

#define FONT_AWESOME_NEUTRAL "\xef\x96\xa4"
#define FONT_AWESOME_HAPPY "\xef\x84\x98"
#define FONT_AWESOME_LAUGHING "\xef\x96\x9b"
#define FONT_AWESOME_FUNNY "\xef\x96\x88"
#define FONT_AWESOME_SAD "\xee\x8e\x84"
#define FONT_AWESOME_ANGRY "\xef\x95\x96"
#define FONT_AWESOME_CRYING "\xef\x96\xb3"
#define FONT_AWESOME_LOVING "\xef\x96\x84"
#define FONT_AWESOME_EMBARRASSED "\xef\x95\xb9"
#define FONT_AWESOME_SURPRISED "\xee\x8d\xab"
#define FONT_AWESOME_SHOCKED "\xee\x8d\xb5"
#define FONT_AWESOME_THINKING "\xee\x8e\x9b"
#define FONT_AWESOME_WINKING "\xef\x93\x9a"
#define FONT_AWESOME_COOL "\xee\x8e\x98"
#define FONT_AWESOME_RELAXED "\xee\x8e\x92"
#define FONT_AWESOME_DELICIOUS "\xee\x8d\xb2"
#define FONT_AWESOME_KISSY "\xef\x96\x98"
#define FONT_AWESOME_CONFIDENT "\xee\x90\x89"
#define FONT_AWESOME_SLEEPY "\xee\x8e\x8d"
#define FONT_AWESOME_SILLY "\xee\x8e\xa4"
#define FONT_AWESOME_CONFUSED "\xee\x8d\xad"
#define FONT_AWESOME_BATTERY_FULL "\xef\x89\x80"
#define FONT_AWESOME_BATTERY_THREE_QUARTERS "\xef\x89\x81"
#define FONT_AWESOME_BATTERY_HALF "\xef\x89\x82"
#define FONT_AWESOME_BATTERY_QUARTER "\xef\x89\x83"
#define FONT_AWESOME_BATTERY_EMPTY "\xef\x89\x84"
#define FONT_AWESOME_BATTERY_SLASH "\xef\x8d\xb7"
#define FONT_AWESOME_BATTERY_BOLT "\xef\x8d\xb6"
#define FONT_AWESOME_WIFI "\xef\x87\xab"
#define FONT_AWESOME_WIFI_FAIR "\xef\x9a\xab"
#define FONT_AWESOME_WIFI_WEAK "\xef\x9a\xaa"
#define FONT_AWESOME_WIFI_SLASH "\xef\x9a\xac"
#define FONT_AWESOME_SIGNAL "\xef\x80\x92"
#define FONT_AWESOME_SIGNAL_STRONG "\xef\x9a\x8f"
#define FONT_AWESOME_SIGNAL_GOOD "\xef\x9a\x8e"
#define FONT_AWESOME_SIGNAL_FAIR "\xef\x9a\x8d"
#define FONT_AWESOME_SIGNAL_WEAK "\xef\x9a\x8c"
#define FONT_AWESOME_SIGNAL_OFF "\xef\x9a\x95"
#define FONT_AWESOME_VOLUME_HIGH "\xef\x80\xa8"
#define FONT_AWESOME_VOLUME "\xef\x9a\xa8"
#define FONT_AWESOME_VOLUME_LOW "\xef\x80\xa7"
#define FONT_AWESOME_VOLUME_XMARK "\xef\x9a\xa9"
#define FONT_AWESOME_MUSIC "\xef\x80\x81"
#define FONT_AWESOME_CHECK "\xef\x80\x8c"
#define FONT_AWESOME_XMARK "\xef\x80\x8d"
#define FONT_AWESOME_POWER_OFF "\xef\x80\x91"
#define FONT_AWESOME_GEAR "\xef\x80\x93"
#define FONT_AWESOME_TRASH "\xef\x87\xb8"
#define FONT_AWESOME_HOUSE "\xef\x80\x95"
#define FONT_AWESOME_IMAGE "\xef\x80\xbe"
#define FONT_AWESOME_PEN_TO_SQUARE "\xef\x81\x84"
#define FONT_AWESOME_BACKWARD_STEP "\xef\x81\x88"
#define FONT_AWESOME_FORWARD_STEP "\xef\x81\x91"
#define FONT_AWESOME_PLAY "\xef\x81\x8b"
#define FONT_AWESOME_PAUSE "\xef\x81\x8c"
#define FONT_AWESOME_STOP "\xef\x81\x8d"
#define FONT_AWESOME_ARROW_LEFT "\xef\x81\xa0"
#define FONT_AWESOME_ARROW_RIGHT "\xef\x81\xa1"
#define FONT_AWESOME_ARROW_UP "\xef\x81\xa2"
#define FONT_AWESOME_ARROW_DOWN "\xef\x81\xa3"
#define FONT_AWESOME_TRIANGLE_EXCLAMATION "\xef\x81\xb1"
#define FONT_AWESOME_BELL "\xef\x83\xb3"
#define FONT_AWESOME_LOCATION_DOT "\xef\x8f\x85"
#define FONT_AWESOME_GLOBE "\xef\x82\xac"
#define FONT_AWESOME_LOCATION_ARROW "\xef\x84\xa4"
#define FONT_AWESOME_SD_CARD "\xef\x9f\x82"
#define FONT_AWESOME_BLUETOOTH "\xef\x8a\x93"
#define FONT_AWESOME_COMMENT "\xef\x81\xb5"
#define FONT_AWESOME_MICROCHIP_AI "\xee\x87\xac"
#define FONT_AWESOME_USER "\xef\x80\x87"
#define FONT_AWESOME_USER_ROBOT "\xee\x81\x8b"
#define FONT_AWESOME_DOWNLOAD "\xef\x80\x99"
#define FONT_AWESOME_LOCK "\xef\x80\xa3"
#define FONT_AWESOME_UNLOCK "\xef\x82\x9c"
#define FONT_AWESOME_KEY "\xef\x82\x84"
#define FONT_AWESOME_LINK "\xef\x83\x81"
#define FONT_AWESOME_CIRCLE_INFO "\xef\x81\x9a"
#define FONT_AWESOME_CIRCLE_QUESTION "\xef\x81\x99"
#define FONT_AWESOME_CIRCLE_CHECK "\xef\x81\x98"
#define FONT_AWESOME_CIRCLE_XMARK "\xef\x81\x97"
#define FONT_AWESOME_CLOCK "\xef\x80\x97"
#define FONT_AWESOME_ALARM_CLOCK "\xef\x8d\x8e"
#define FONT_AWESOME_SPINNER "\xef\x84\x90"
#define FONT_AWESOME_TEMPERATURE_HALF "\xef\x8b\x89"
#define FONT_AWESOME_HEADPHONES "\xef\x80\xa5"
#define FONT_AWESOME_MICROPHONE "\xef\x84\xb0"
#define FONT_AWESOME_MICROPHONE_SLASH "\xef\x84\xb1"
#define FONT_AWESOME_COMMENT_QUESTION "\xee\x85\x8b"
#define FONT_AWESOME_CAMERA "\xef\x80\xb0"
#define FONT_AWESOME_CALENDAR "\xef\x84\xb3"
#define FONT_AWESOME_ENVELOPE "\xef\x83\xa0"
#define FONT_AWESOME_BRIGHTNESS "\xee\x83\x89"
#define FONT_AWESOME_PHONE "\xef\x82\x95"
#define FONT_AWESOME_COMPASS "\xef\x85\x8e"
#define FONT_AWESOME_CALCULATOR "\xef\x87\xac"
#define FONT_AWESOME_GLASSES "\xef\x94\xb0"
#define FONT_AWESOME_MAGNIFYING_GLASS "\xef\x80\x82"
#define FONT_AWESOME_HEART "\xef\x80\x84"
#define FONT_AWESOME_STAR "\xef\x80\x85"
#define FONT_AWESOME_GAMEPAD "\xef\x84\x9b"
#define FONT_AWESOME_WATCH "\xef\x8b\xa1"
#define FONT_AWESOME_ARROWS_REPEAT "\xef\x8d\xa4"
#define FONT_AWESOME_ARROWS_ROTATE "\xef\x80\xa1"
#define FONT_AWESOME_ANGLE_LEFT "\xef\x84\x84"
#define FONT_AWESOME_ANGLE_RIGHT "\xef\x84\x85"
#define FONT_AWESOME_ANGLE_UP "\xef\x84\x86"
#define FONT_AWESOME_ANGLE_DOWN "\xef\x84\x87"
#define FONT_AWESOME_ANGLES_LEFT "\xef\x84\x80"
#define FONT_AWESOME_ANGLES_RIGHT "\xef\x84\x81"
#define FONT_AWESOME_ANGLES_UP "\xef\x84\x82"
#define FONT_AWESOME_ANGLES_DOWN "\xef\x84\x83"
#define FONT_AWESOME_CLOUD_ARROW_DOWN "\xef\x83\xad"
#define FONT_AWESOME_CLOUD_ARROW_UP "\xef\x83\xae"
#define FONT_AWESOME_CLOUD_SLASH "\xee\x84\xb7"
#define FONT_AWESOME_SUN "\xef\x86\x85"
#define FONT_AWESOME_MOON "\xef\x86\x86"
#define FONT_AWESOME_CLOUD "\xef\x83\x82"
#define FONT_AWESOME_CLOUDS "\xef\x9d\x84"
#define FONT_AWESOME_CLOUD_SUN "\xef\x9d\x86"
#define FONT_AWESOME_CLOUD_SUN_RAIN "\xef\x9d\x83"
#define FONT_AWESOME_CLOUD_MOON "\xef\x9b\x83"
#define FONT_AWESOME_CLOUD_BOLT "\xef\x9d\xac"
#define FONT_AWESOME_CLOUD_HAIL "\xef\x9c\xba"
#define FONT_AWESOME_CLOUD_SLEET "\xef\x9d\x81"
#define FONT_AWESOME_CLOUD_DRIZZLE "\xef\x9c\xb8"
#define FONT_AWESOME_CLOUD_FOG "\xef\x9d\x8e"
#define FONT_AWESOME_CLOUD_RAIN "\xef\x9c\xbd"
#define FONT_AWESOME_CLOUD_SHOWERS "\xef\x9c\xbf"
#define FONT_AWESOME_CLOUD_SHOWERS_HEAVY "\xef\x9d\x80"
#define FONT_AWESOME_SNOWFLAKE "\xef\x8b\x9c"
#define FONT_AWESOME_SNOWFLAKES "\xef\x9f\x8f"
#define FONT_AWESOME_SMOG "\xef\x9d\x9f"
#define FONT_AWESOME_WIND "\xef\x9c\xae"
#define FONT_AWESOME_HURRICANE "\xef\x9d\x91"
#define FONT_AWESOME_TORNADO "\xef\x9d\xaf"

// 符号数据表声明
extern const font_awesome_symbol_t font_awesome_symbols[];
extern const size_t font_awesome_symbol_count;

// 内联函数实现
static inline const char* font_awesome_get_utf8(const char* name) {
    if (!name) return NULL;
    
    for (size_t i = 0; i < font_awesome_symbol_count; i++) {
        if (strcmp(font_awesome_symbols[i].name, name) == 0) {
            return font_awesome_symbols[i].utf8_string;
        }
    }
    return NULL;
}

#endif
