// Copyright 2018-2019 Espressif Systems (Shanghai) PTE LTD
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


#include <stdint.h>
#include "dsps_fft_tables.h"


const uint16_t bitrev2r_table_16_fc32[] = {
    8, 64, 16, 32, 24, 96, 40, 80, 56, 112, 88, 104,
};

const uint16_t bitrev2r_table_32_fc32[] = {
    8, 128, 16, 64, 24, 192, 40, 160, 48, 96, 56, 224, 72, 144, 88, 208,
    104, 176, 120, 240, 152, 200, 184, 232,
};

const uint16_t bitrev2r_table_64_fc32[] = {
    8, 256, 16, 128, 24, 384, 32, 64, 40, 320, 48, 192, 56, 448, 72, 288,
    80, 160, 88, 416, 104, 352, 112, 224, 120, 480, 136, 272, 152, 400, 168, 336,
    176, 208, 184, 464, 200, 304, 216, 432, 232, 368, 248, 496, 280, 392, 296, 328,
    312, 456, 344, 424, 376, 488, 440, 472,
};

const uint16_t bitrev2r_table_128_fc32[] = {
    8, 512, 16, 256, 24, 768, 32, 128, 40, 640, 48, 384, 56, 896, 72, 576,
    80, 320, 88, 832, 96, 192, 104, 704, 112, 448, 120, 960, 136, 544, 144, 288,
    152, 800, 168, 672, 176, 416, 184, 928, 200, 608, 208, 352, 216, 864, 232, 736,
    240, 480, 248, 992, 264, 528, 280, 784, 296, 656, 304, 400, 312, 912, 328, 592,
    344, 848, 360, 720, 368, 464, 376, 976, 392, 560, 408, 816, 424, 688, 440, 944,
    456, 624, 472, 880, 488, 752, 504, 1008, 536, 776, 552, 648, 568, 904, 600, 840,
    616, 712, 632, 968, 664, 808, 696, 936, 728, 872, 760, 1000, 824, 920, 888, 984,
};

const uint16_t bitrev2r_table_256_fc32[] = {
    8, 1024, 16, 512, 24, 1536, 32, 256, 40, 1280, 48, 768, 56, 1792, 64, 128,
    72, 1152, 80, 640, 88, 1664, 96, 384, 104, 1408, 112, 896, 120, 1920, 136, 1088,
    144, 576, 152, 1600, 160, 320, 168, 1344, 176, 832, 184, 1856, 200, 1216, 208, 704,
    216, 1728, 224, 448, 232, 1472, 240, 960, 248, 1984, 264, 1056, 272, 544, 280, 1568,
    296, 1312, 304, 800, 312, 1824, 328, 1184, 336, 672, 344, 1696, 352, 416, 360, 1440,
    368, 928, 376, 1952, 392, 1120, 400, 608, 408, 1632, 424, 1376, 432, 864, 440, 1888,
    456, 1248, 464, 736, 472, 1760, 488, 1504, 496, 992, 504, 2016, 520, 1040, 536, 1552,
    552, 1296, 560, 784, 568, 1808, 584, 1168, 592, 656, 600, 1680, 616, 1424, 624, 912,
    632, 1936, 648, 1104, 664, 1616, 680, 1360, 688, 848, 696, 1872, 712, 1232, 728, 1744,
    744, 1488, 752, 976, 760, 2000, 776, 1072, 792, 1584, 808, 1328, 824, 1840, 840, 1200,
    856, 1712, 872, 1456, 880, 944, 888, 1968, 904, 1136, 920, 1648, 936, 1392, 952, 1904,
    968, 1264, 984, 1776, 1000, 1520, 1016, 2032, 1048, 1544, 1064, 1288, 1080, 1800, 1096, 1160,
    1112, 1672, 1128, 1416, 1144, 1928, 1176, 1608, 1192, 1352, 1208, 1864, 1240, 1736, 1256, 1480,
    1272, 1992, 1304, 1576, 1336, 1832, 1368, 1704, 1384, 1448, 1400, 1960, 1432, 1640, 1464, 1896,
    1496, 1768, 1528, 2024, 1592, 1816, 1624, 1688, 1656, 1944, 1720, 1880, 1784, 2008, 1912, 1976,
};

const uint16_t bitrev2r_table_512_fc32[] = {
    8, 2048, 16, 1024, 24, 3072, 32, 512, 40, 2560, 48, 1536, 56, 3584, 64, 256,
    72, 2304, 80, 1280, 88, 3328, 96, 768, 104, 2816, 112, 1792, 120, 3840, 136, 2176,
    144, 1152, 152, 3200, 160, 640, 168, 2688, 176, 1664, 184, 3712, 192, 384, 200, 2432,
    208, 1408, 216, 3456, 224, 896, 232, 2944, 240, 1920, 248, 3968, 264, 2112, 272, 1088,
    280, 3136, 288, 576, 296, 2624, 304, 1600, 312, 3648, 328, 2368, 336, 1344, 344, 3392,
    352, 832, 360, 2880, 368, 1856, 376, 3904, 392, 2240, 400, 1216, 408, 3264, 416, 704,
    424, 2752, 432, 1728, 440, 3776, 456, 2496, 464, 1472, 472, 3520, 480, 960, 488, 3008,
    496, 1984, 504, 4032, 520, 2080, 528, 1056, 536, 3104, 552, 2592, 560, 1568, 568, 3616,
    584, 2336, 592, 1312, 600, 3360, 608, 800, 616, 2848, 624, 1824, 632, 3872, 648, 2208,
    656, 1184, 664, 3232, 680, 2720, 688, 1696, 696, 3744, 712, 2464, 720, 1440, 728, 3488,
    736, 928, 744, 2976, 752, 1952, 760, 4000, 776, 2144, 784, 1120, 792, 3168, 808, 2656,
    816, 1632, 824, 3680, 840, 2400, 848, 1376, 856, 3424, 872, 2912, 880, 1888, 888, 3936,
    904, 2272, 912, 1248, 920, 3296, 936, 2784, 944, 1760, 952, 3808, 968, 2528, 976, 1504,
    984, 3552, 1000, 3040, 1008, 2016, 1016, 4064, 1032, 2064, 1048, 3088, 1064, 2576, 1072, 1552,
    1080, 3600, 1096, 2320, 1104, 1296, 1112, 3344, 1128, 2832, 1136, 1808, 1144, 3856, 1160, 2192,
    1176, 3216, 1192, 2704, 1200, 1680, 1208, 3728, 1224, 2448, 1232, 1424, 1240, 3472, 1256, 2960,
    1264, 1936, 1272, 3984, 1288, 2128, 1304, 3152, 1320, 2640, 1328, 1616, 1336, 3664, 1352, 2384,
    1368, 3408, 1384, 2896, 1392, 1872, 1400, 3920, 1416, 2256, 1432, 3280, 1448, 2768, 1456, 1744,
    1464, 3792, 1480, 2512, 1496, 3536, 1512, 3024, 1520, 2000, 1528, 4048, 1544, 2096, 1560, 3120,
    1576, 2608, 1592, 3632, 1608, 2352, 1624, 3376, 1640, 2864, 1648, 1840, 1656, 3888, 1672, 2224,
    1688, 3248, 1704, 2736, 1720, 3760, 1736, 2480, 1752, 3504, 1768, 2992, 1776, 1968, 1784, 4016,
    1800, 2160, 1816, 3184, 1832, 2672, 1848, 3696, 1864, 2416, 1880, 3440, 1896, 2928, 1912, 3952,
    1928, 2288, 1944, 3312, 1960, 2800, 1976, 3824, 1992, 2544, 2008, 3568, 2024, 3056, 2040, 4080,
    2072, 3080, 2088, 2568, 2104, 3592, 2120, 2312, 2136, 3336, 2152, 2824, 2168, 3848, 2200, 3208,
    2216, 2696, 2232, 3720, 2248, 2440, 2264, 3464, 2280, 2952, 2296, 3976, 2328, 3144, 2344, 2632,
    2360, 3656, 2392, 3400, 2408, 2888, 2424, 3912, 2456, 3272, 2472, 2760, 2488, 3784, 2520, 3528,
    2536, 3016, 2552, 4040, 2584, 3112, 2616, 3624, 2648, 3368, 2664, 2856, 2680, 3880, 2712, 3240,
    2744, 3752, 2776, 3496, 2792, 2984, 2808, 4008, 2840, 3176, 2872, 3688, 2904, 3432, 2936, 3944,
    2968, 3304, 3000, 3816, 3032, 3560, 3064, 4072, 3128, 3608, 3160, 3352, 3192, 3864, 3256, 3736,
    3288, 3480, 3320, 3992, 3384, 3672, 3448, 3928, 3512, 3800, 3576, 4056, 3704, 3896, 3832, 4024,
};

const uint16_t bitrev2r_table_1024_fc32[] = {
    8, 4096, 16, 2048, 24, 6144, 32, 1024, 40, 5120, 48, 3072, 56, 7168, 64, 512,
    72, 4608, 80, 2560, 88, 6656, 96, 1536, 104, 5632, 112, 3584, 120, 7680, 128, 256,
    136, 4352, 144, 2304, 152, 6400, 160, 1280, 168, 5376, 176, 3328, 184, 7424, 192, 768,
    200, 4864, 208, 2816, 216, 6912, 224, 1792, 232, 5888, 240, 3840, 248, 7936, 264, 4224,
    272, 2176, 280, 6272, 288, 1152, 296, 5248, 304, 3200, 312, 7296, 320, 640, 328, 4736,
    336, 2688, 344, 6784, 352, 1664, 360, 5760, 368, 3712, 376, 7808, 392, 4480, 400, 2432,
    408, 6528, 416, 1408, 424, 5504, 432, 3456, 440, 7552, 448, 896, 456, 4992, 464, 2944,
    472, 7040, 480, 1920, 488, 6016, 496, 3968, 504, 8064, 520, 4160, 528, 2112, 536, 6208,
    544, 1088, 552, 5184, 560, 3136, 568, 7232, 584, 4672, 592, 2624, 600, 6720, 608, 1600,
    616, 5696, 624, 3648, 632, 7744, 648, 4416, 656, 2368, 664, 6464, 672, 1344, 680, 5440,
    688, 3392, 696, 7488, 704, 832, 712, 4928, 720, 2880, 728, 6976, 736, 1856, 744, 5952,
    752, 3904, 760, 8000, 776, 4288, 784, 2240, 792, 6336, 800, 1216, 808, 5312, 816, 3264,
    824, 7360, 840, 4800, 848, 2752, 856, 6848, 864, 1728, 872, 5824, 880, 3776, 888, 7872,
    904, 4544, 912, 2496, 920, 6592, 928, 1472, 936, 5568, 944, 3520, 952, 7616, 968, 5056,
    976, 3008, 984, 7104, 992, 1984, 1000, 6080, 1008, 4032, 1016, 8128, 1032, 4128, 1040, 2080,
    1048, 6176, 1064, 5152, 1072, 3104, 1080, 7200, 1096, 4640, 1104, 2592, 1112, 6688, 1120, 1568,
    1128, 5664, 1136, 3616, 1144, 7712, 1160, 4384, 1168, 2336, 1176, 6432, 1184, 1312, 1192, 5408,
    1200, 3360, 1208, 7456, 1224, 4896, 1232, 2848, 1240, 6944, 1248, 1824, 1256, 5920, 1264, 3872,
    1272, 7968, 1288, 4256, 1296, 2208, 1304, 6304, 1320, 5280, 1328, 3232, 1336, 7328, 1352, 4768,
    1360, 2720, 1368, 6816, 1376, 1696, 1384, 5792, 1392, 3744, 1400, 7840, 1416, 4512, 1424, 2464,
    1432, 6560, 1448, 5536, 1456, 3488, 1464, 7584, 1480, 5024, 1488, 2976, 1496, 7072, 1504, 1952,
    1512, 6048, 1520, 4000, 1528, 8096, 1544, 4192, 1552, 2144, 1560, 6240, 1576, 5216, 1584, 3168,
    1592, 7264, 1608, 4704, 1616, 2656, 1624, 6752, 1640, 5728, 1648, 3680, 1656, 7776, 1672, 4448,
    1680, 2400, 1688, 6496, 1704, 5472, 1712, 3424, 1720, 7520, 1736, 4960, 1744, 2912, 1752, 7008,
    1760, 1888, 1768, 5984, 1776, 3936, 1784, 8032, 1800, 4320, 1808, 2272, 1816, 6368, 1832, 5344,
    1840, 3296, 1848, 7392, 1864, 4832, 1872, 2784, 1880, 6880, 1896, 5856, 1904, 3808, 1912, 7904,
    1928, 4576, 1936, 2528, 1944, 6624, 1960, 5600, 1968, 3552, 1976, 7648, 1992, 5088, 2000, 3040,
    2008, 7136, 2024, 6112, 2032, 4064, 2040, 8160, 2056, 4112, 2072, 6160, 2088, 5136, 2096, 3088,
    2104, 7184, 2120, 4624, 2128, 2576, 2136, 6672, 2152, 5648, 2160, 3600, 2168, 7696, 2184, 4368,
    2192, 2320, 2200, 6416, 2216, 5392, 2224, 3344, 2232, 7440, 2248, 4880, 2256, 2832, 2264, 6928,
    2280, 5904, 2288, 3856, 2296, 7952, 2312, 4240, 2328, 6288, 2344, 5264, 2352, 3216, 2360, 7312,
    2376, 4752, 2384, 2704, 2392, 6800, 2408, 5776, 2416, 3728, 2424, 7824, 2440, 4496, 2456, 6544,
    2472, 5520, 2480, 3472, 2488, 7568, 2504, 5008, 2512, 2960, 2520, 7056, 2536, 6032, 2544, 3984,
    2552, 8080, 2568, 4176, 2584, 6224, 2600, 5200, 2608, 3152, 2616, 7248, 2632, 4688, 2648, 6736,
    2664, 5712, 2672, 3664, 2680, 7760, 2696, 4432, 2712, 6480, 2728, 5456, 2736, 3408, 2744, 7504,
    2760, 4944, 2768, 2896, 2776, 6992, 2792, 5968, 2800, 3920, 2808, 8016, 2824, 4304, 2840, 6352,
    2856, 5328, 2864, 3280, 2872, 7376, 2888, 4816, 2904, 6864, 2920, 5840, 2928, 3792, 2936, 7888,
    2952, 4560, 2968, 6608, 2984, 5584, 2992, 3536, 3000, 7632, 3016, 5072, 3032, 7120, 3048, 6096,
    3056, 4048, 3064, 8144, 3080, 4144, 3096, 6192, 3112, 5168, 3128, 7216, 3144, 4656, 3160, 6704,
    3176, 5680, 3184, 3632, 3192, 7728, 3208, 4400, 3224, 6448, 3240, 5424, 3248, 3376, 3256, 7472,
    3272, 4912, 3288, 6960, 3304, 5936, 3312, 3888, 3320, 7984, 3336, 4272, 3352, 6320, 3368, 5296,
    3384, 7344, 3400, 4784, 3416, 6832, 3432, 5808, 3440, 3760, 3448, 7856, 3464, 4528, 3480, 6576,
    3496, 5552, 3512, 7600, 3528, 5040, 3544, 7088, 3560, 6064, 3568, 4016, 3576, 8112, 3592, 4208,
    3608, 6256, 3624, 5232, 3640, 7280, 3656, 4720, 3672, 6768, 3688, 5744, 3704, 7792, 3720, 4464,
    3736, 6512, 3752, 5488, 3768, 7536, 3784, 4976, 3800, 7024, 3816, 6000, 3824, 3952, 3832, 8048,
    3848, 4336, 3864, 6384, 3880, 5360, 3896, 7408, 3912, 4848, 3928, 6896, 3944, 5872, 3960, 7920,
    3976, 4592, 3992, 6640, 4008, 5616, 4024, 7664, 4040, 5104, 4056, 7152, 4072, 6128, 4088, 8176,
    4120, 6152, 4136, 5128, 4152, 7176, 4168, 4616, 4184, 6664, 4200, 5640, 4216, 7688, 4232, 4360,
    4248, 6408, 4264, 5384, 4280, 7432, 4296, 4872, 4312, 6920, 4328, 5896, 4344, 7944, 4376, 6280,
    4392, 5256, 4408, 7304, 4424, 4744, 4440, 6792, 4456, 5768, 4472, 7816, 4504, 6536, 4520, 5512,
    4536, 7560, 4552, 5000, 4568, 7048, 4584, 6024, 4600, 8072, 4632, 6216, 4648, 5192, 4664, 7240,
    4696, 6728, 4712, 5704, 4728, 7752, 4760, 6472, 4776, 5448, 4792, 7496, 4808, 4936, 4824, 6984,
    4840, 5960, 4856, 8008, 4888, 6344, 4904, 5320, 4920, 7368, 4952, 6856, 4968, 5832, 4984, 7880,
    5016, 6600, 5032, 5576, 5048, 7624, 5080, 7112, 5096, 6088, 5112, 8136, 5144, 6184, 5176, 7208,
    5208, 6696, 5224, 5672, 5240, 7720, 5272, 6440, 5288, 5416, 5304, 7464, 5336, 6952, 5352, 5928,
    5368, 7976, 5400, 6312, 5432, 7336, 5464, 6824, 5480, 5800, 5496, 7848, 5528, 6568, 5560, 7592,
    5592, 7080, 5608, 6056, 5624, 8104, 5656, 6248, 5688, 7272, 5720, 6760, 5752, 7784, 5784, 6504,
    5816, 7528, 5848, 7016, 5864, 5992, 5880, 8040, 5912, 6376, 5944, 7400, 5976, 6888, 6008, 7912,
    6040, 6632, 6072, 7656, 6104, 7144, 6136, 8168, 6200, 7192, 6232, 6680, 6264, 7704, 6296, 6424,
    6328, 7448, 6360, 6936, 6392, 7960, 6456, 7320, 6488, 6808, 6520, 7832, 6584, 7576, 6616, 7064,
    6648, 8088, 6712, 7256, 6776, 7768, 6840, 7512, 6872, 7000, 6904, 8024, 6968, 7384, 7032, 7896,
    7096, 7640, 7160, 8152, 7288, 7736, 7352, 7480, 7416, 7992, 7544, 7864, 7672, 8120, 7928, 8056,
};

const uint16_t bitrev2r_table_2048_fc32[] = {
    8, 8192, 16, 4096, 24, 12288, 32, 2048, 40, 10240, 48, 6144, 56, 14336, 64, 1024,
    72, 9216, 80, 5120, 88, 13312, 96, 3072, 104, 11264, 112, 7168, 120, 15360, 128, 512,
    136, 8704, 144, 4608, 152, 12800, 160, 2560, 168, 10752, 176, 6656, 184, 14848, 192, 1536,
    200, 9728, 208, 5632, 216, 13824, 224, 3584, 232, 11776, 240, 7680, 248, 15872, 264, 8448,
    272, 4352, 280, 12544, 288, 2304, 296, 10496, 304, 6400, 312, 14592, 320, 1280, 328, 9472,
    336, 5376, 344, 13568, 352, 3328, 360, 11520, 368, 7424, 376, 15616, 384, 768, 392, 8960,
    400, 4864, 408, 13056, 416, 2816, 424, 11008, 432, 6912, 440, 15104, 448, 1792, 456, 9984,
    464, 5888, 472, 14080, 480, 3840, 488, 12032, 496, 7936, 504, 16128, 520, 8320, 528, 4224,
    536, 12416, 544, 2176, 552, 10368, 560, 6272, 568, 14464, 576, 1152, 584, 9344, 592, 5248,
    600, 13440, 608, 3200, 616, 11392, 624, 7296, 632, 15488, 648, 8832, 656, 4736, 664, 12928,
    672, 2688, 680, 10880, 688, 6784, 696, 14976, 704, 1664, 712, 9856, 720, 5760, 728, 13952,
    736, 3712, 744, 11904, 752, 7808, 760, 16000, 776, 8576, 784, 4480, 792, 12672, 800, 2432,
    808, 10624, 816, 6528, 824, 14720, 832, 1408, 840, 9600, 848, 5504, 856, 13696, 864, 3456,
    872, 11648, 880, 7552, 888, 15744, 904, 9088, 912, 4992, 920, 13184, 928, 2944, 936, 11136,
    944, 7040, 952, 15232, 960, 1920, 968, 10112, 976, 6016, 984, 14208, 992, 3968, 1000, 12160,
    1008, 8064, 1016, 16256, 1032, 8256, 1040, 4160, 1048, 12352, 1056, 2112, 1064, 10304, 1072, 6208,
    1080, 14400, 1096, 9280, 1104, 5184, 1112, 13376, 1120, 3136, 1128, 11328, 1136, 7232, 1144, 15424,
    1160, 8768, 1168, 4672, 1176, 12864, 1184, 2624, 1192, 10816, 1200, 6720, 1208, 14912, 1216, 1600,
    1224, 9792, 1232, 5696, 1240, 13888, 1248, 3648, 1256, 11840, 1264, 7744, 1272, 15936, 1288, 8512,
    1296, 4416, 1304, 12608, 1312, 2368, 1320, 10560, 1328, 6464, 1336, 14656, 1352, 9536, 1360, 5440,
    1368, 13632, 1376, 3392, 1384, 11584, 1392, 7488, 1400, 15680, 1416, 9024, 1424, 4928, 1432, 13120,
    1440, 2880, 1448, 11072, 1456, 6976, 1464, 15168, 1472, 1856, 1480, 10048, 1488, 5952, 1496, 14144,
    1504, 3904, 1512, 12096, 1520, 8000, 1528, 16192, 1544, 8384, 1552, 4288, 1560, 12480, 1568, 2240,
    1576, 10432, 1584, 6336, 1592, 14528, 1608, 9408, 1616, 5312, 1624, 13504, 1632, 3264, 1640, 11456,
    1648, 7360, 1656, 15552, 1672, 8896, 1680, 4800, 1688, 12992, 1696, 2752, 1704, 10944, 1712, 6848,
    1720, 15040, 1736, 9920, 1744, 5824, 1752, 14016, 1760, 3776, 1768, 11968, 1776, 7872, 1784, 16064,
    1800, 8640, 1808, 4544, 1816, 12736, 1824, 2496, 1832, 10688, 1840, 6592, 1848, 14784, 1864, 9664,
    1872, 5568, 1880, 13760, 1888, 3520, 1896, 11712, 1904, 7616, 1912, 15808, 1928, 9152, 1936, 5056,
    1944, 13248, 1952, 3008, 1960, 11200, 1968, 7104, 1976, 15296, 1992, 10176, 2000, 6080, 2008, 14272,
    2016, 4032, 2024, 12224, 2032, 8128, 2040, 16320, 2056, 8224, 2064, 4128, 2072, 12320, 2088, 10272,
    2096, 6176, 2104, 14368, 2120, 9248, 2128, 5152, 2136, 13344, 2144, 3104, 2152, 11296, 2160, 7200,
    2168, 15392, 2184, 8736, 2192, 4640, 2200, 12832, 2208, 2592, 2216, 10784, 2224, 6688, 2232, 14880,
    2248, 9760, 2256, 5664, 2264, 13856, 2272, 3616, 2280, 11808, 2288, 7712, 2296, 15904, 2312, 8480,
    2320, 4384, 2328, 12576, 2344, 10528, 2352, 6432, 2360, 14624, 2376, 9504, 2384, 5408, 2392, 13600,
    2400, 3360, 2408, 11552, 2416, 7456, 2424, 15648, 2440, 8992, 2448, 4896, 2456, 13088, 2464, 2848,
    2472, 11040, 2480, 6944, 2488, 15136, 2504, 10016, 2512, 5920, 2520, 14112, 2528, 3872, 2536, 12064,
    2544, 7968, 2552, 16160, 2568, 8352, 2576, 4256, 2584, 12448, 2600, 10400, 2608, 6304, 2616, 14496,
    2632, 9376, 2640, 5280, 2648, 13472, 2656, 3232, 2664, 11424, 2672, 7328, 2680, 15520, 2696, 8864,
    2704, 4768, 2712, 12960, 2728, 10912, 2736, 6816, 2744, 15008, 2760, 9888, 2768, 5792, 2776, 13984,
    2784, 3744, 2792, 11936, 2800, 7840, 2808, 16032, 2824, 8608, 2832, 4512, 2840, 12704, 2856, 10656,
    2864, 6560, 2872, 14752, 2888, 9632, 2896, 5536, 2904, 13728, 2912, 3488, 2920, 11680, 2928, 7584,
    2936, 15776, 2952, 9120, 2960, 5024, 2968, 13216, 2984, 11168, 2992, 7072, 3000, 15264, 3016, 10144,
    3024, 6048, 3032, 14240, 3040, 4000, 3048, 12192, 3056, 8096, 3064, 16288, 3080, 8288, 3088, 4192,
    3096, 12384, 3112, 10336, 3120, 6240, 3128, 14432, 3144, 9312, 3152, 5216, 3160, 13408, 3176, 11360,
    3184, 7264, 3192, 15456, 3208, 8800, 3216, 4704, 3224, 12896, 3240, 10848, 3248, 6752, 3256, 14944,
    3272, 9824, 3280, 5728, 3288, 13920, 3296, 3680, 3304, 11872, 3312, 7776, 3320, 15968, 3336, 8544,
    3344, 4448, 3352, 12640, 3368, 10592, 3376, 6496, 3384, 14688, 3400, 9568, 3408, 5472, 3416, 13664,
    3432, 11616, 3440, 7520, 3448, 15712, 3464, 9056, 3472, 4960, 3480, 13152, 3496, 11104, 3504, 7008,
    3512, 15200, 3528, 10080, 3536, 5984, 3544, 14176, 3552, 3936, 3560, 12128, 3568, 8032, 3576, 16224,
    3592, 8416, 3600, 4320, 3608, 12512, 3624, 10464, 3632, 6368, 3640, 14560, 3656, 9440, 3664, 5344,
    3672, 13536, 3688, 11488, 3696, 7392, 3704, 15584, 3720, 8928, 3728, 4832, 3736, 13024, 3752, 10976,
    3760, 6880, 3768, 15072, 3784, 9952, 3792, 5856, 3800, 14048, 3816, 12000, 3824, 7904, 3832, 16096,
    3848, 8672, 3856, 4576, 3864, 12768, 3880, 10720, 3888, 6624, 3896, 14816, 3912, 9696, 3920, 5600,
    3928, 13792, 3944, 11744, 3952, 7648, 3960, 15840, 3976, 9184, 3984, 5088, 3992, 13280, 4008, 11232,
    4016, 7136, 4024, 15328, 4040, 10208, 4048, 6112, 4056, 14304, 4072, 12256, 4080, 8160, 4088, 16352,
    4104, 8208, 4120, 12304, 4136, 10256, 4144, 6160, 4152, 14352, 4168, 9232, 4176, 5136, 4184, 13328,
    4200, 11280, 4208, 7184, 4216, 15376, 4232, 8720, 4240, 4624, 4248, 12816, 4264, 10768, 4272, 6672,
    4280, 14864, 4296, 9744, 4304, 5648, 4312, 13840, 4328, 11792, 4336, 7696, 4344, 15888, 4360, 8464,
    4376, 12560, 4392, 10512, 4400, 6416, 4408, 14608, 4424, 9488, 4432, 5392, 4440, 13584, 4456, 11536,
    4464, 7440, 4472, 15632, 4488, 8976, 4496, 4880, 4504, 13072, 4520, 11024, 4528, 6928, 4536, 15120,
    4552, 10000, 4560, 5904, 4568, 14096, 4584, 12048, 4592, 7952, 4600, 16144, 4616, 8336, 4632, 12432,
    4648, 10384, 4656, 6288, 4664, 14480, 4680, 9360, 4688, 5264, 4696, 13456, 4712, 11408, 4720, 7312,
    4728, 15504, 4744, 8848, 4760, 12944, 4776, 10896, 4784, 6800, 4792, 14992, 4808, 9872, 4816, 5776,
    4824, 13968, 4840, 11920, 4848, 7824, 4856, 16016, 4872, 8592, 4888, 12688, 4904, 10640, 4912, 6544,
    4920, 14736, 4936, 9616, 4944, 5520, 4952, 13712, 4968, 11664, 4976, 7568, 4984, 15760, 5000, 9104,
    5016, 13200, 5032, 11152, 5040, 7056, 5048, 15248, 5064, 10128, 5072, 6032, 5080, 14224, 5096, 12176,
    5104, 8080, 5112, 16272, 5128, 8272, 5144, 12368, 5160, 10320, 5168, 6224, 5176, 14416, 5192, 9296,
    5208, 13392, 5224, 11344, 5232, 7248, 5240, 15440, 5256, 8784, 5272, 12880, 5288, 10832, 5296, 6736,
    5304, 14928, 5320, 9808, 5328, 5712, 5336, 13904, 5352, 11856, 5360, 7760, 5368, 15952, 5384, 8528,
    5400, 12624, 5416, 10576, 5424, 6480, 5432, 14672, 5448, 9552, 5464, 13648, 5480, 11600, 5488, 7504,
    5496, 15696, 5512, 9040, 5528, 13136, 5544, 11088, 5552, 6992, 5560, 15184, 5576, 10064, 5584, 5968,
    5592, 14160, 5608, 12112, 5616, 8016, 5624, 16208, 5640, 8400, 5656, 12496, 5672, 10448, 5680, 6352,
    5688, 14544, 5704, 9424, 5720, 13520, 5736, 11472, 5744, 7376, 5752, 15568, 5768, 8912, 5784, 13008,
    5800, 10960, 5808, 6864, 5816, 15056, 5832, 9936, 5848, 14032, 5864, 11984, 5872, 7888, 5880, 16080,
    5896, 8656, 5912, 12752, 5928, 10704, 5936, 6608, 5944, 14800, 5960, 9680, 5976, 13776, 5992, 11728,
    6000, 7632, 6008, 15824, 6024, 9168, 6040, 13264, 6056, 11216, 6064, 7120, 6072, 15312, 6088, 10192,
    6104, 14288, 6120, 12240, 6128, 8144, 6136, 16336, 6152, 8240, 6168, 12336, 6184, 10288, 6200, 14384,
    6216, 9264, 6232, 13360, 6248, 11312, 6256, 7216, 6264, 15408, 6280, 8752, 6296, 12848, 6312, 10800,
    6320, 6704, 6328, 14896, 6344, 9776, 6360, 13872, 6376, 11824, 6384, 7728, 6392, 15920, 6408, 8496,
    6424, 12592, 6440, 10544, 6456, 14640, 6472, 9520, 6488, 13616, 6504, 11568, 6512, 7472, 6520, 15664,
    6536, 9008, 6552, 13104, 6568, 11056, 6576, 6960, 6584, 15152, 6600, 10032, 6616, 14128, 6632, 12080,
    6640, 7984, 6648, 16176, 6664, 8368, 6680, 12464, 6696, 10416, 6712, 14512, 6728, 9392, 6744, 13488,
    6760, 11440, 6768, 7344, 6776, 15536, 6792, 8880, 6808, 12976, 6824, 10928, 6840, 15024, 6856, 9904,
    6872, 14000, 6888, 11952, 6896, 7856, 6904, 16048, 6920, 8624, 6936, 12720, 6952, 10672, 6968, 14768,
    6984, 9648, 7000, 13744, 7016, 11696, 7024, 7600, 7032, 15792, 7048, 9136, 7064, 13232, 7080, 11184,
    7096, 15280, 7112, 10160, 7128, 14256, 7144, 12208, 7152, 8112, 7160, 16304, 7176, 8304, 7192, 12400,
    7208, 10352, 7224, 14448, 7240, 9328, 7256, 13424, 7272, 11376, 7288, 15472, 7304, 8816, 7320, 12912,
    7336, 10864, 7352, 14960, 7368, 9840, 7384, 13936, 7400, 11888, 7408, 7792, 7416, 15984, 7432, 8560,
    7448, 12656, 7464, 10608, 7480, 14704, 7496, 9584, 7512, 13680, 7528, 11632, 7544, 15728, 7560, 9072,
    7576, 13168, 7592, 11120, 7608, 15216, 7624, 10096, 7640, 14192, 7656, 12144, 7664, 8048, 7672, 16240,
    7688, 8432, 7704, 12528, 7720, 10480, 7736, 14576, 7752, 9456, 7768, 13552, 7784, 11504, 7800, 15600,
    7816, 8944, 7832, 13040, 7848, 10992, 7864, 15088, 7880, 9968, 7896, 14064, 7912, 12016, 7928, 16112,
    7944, 8688, 7960, 12784, 7976, 10736, 7992, 14832, 8008, 9712, 8024, 13808, 8040, 11760, 8056, 15856,
    8072, 9200, 8088, 13296, 8104, 11248, 8120, 15344, 8136, 10224, 8152, 14320, 8168, 12272, 8184, 16368,
    8216, 12296, 8232, 10248, 8248, 14344, 8264, 9224, 8280, 13320, 8296, 11272, 8312, 15368, 8328, 8712,
    8344, 12808, 8360, 10760, 8376, 14856, 8392, 9736, 8408, 13832, 8424, 11784, 8440, 15880, 8472, 12552,
    8488, 10504, 8504, 14600, 8520, 9480, 8536, 13576, 8552, 11528, 8568, 15624, 8584, 8968, 8600, 13064,
    8616, 11016, 8632, 15112, 8648, 9992, 8664, 14088, 8680, 12040, 8696, 16136, 8728, 12424, 8744, 10376,
    8760, 14472, 8776, 9352, 8792, 13448, 8808, 11400, 8824, 15496, 8856, 12936, 8872, 10888, 8888, 14984,
    8904, 9864, 8920, 13960, 8936, 11912, 8952, 16008, 8984, 12680, 9000, 10632, 9016, 14728, 9032, 9608,
    9048, 13704, 9064, 11656, 9080, 15752, 9112, 13192, 9128, 11144, 9144, 15240, 9160, 10120, 9176, 14216,
    9192, 12168, 9208, 16264, 9240, 12360, 9256, 10312, 9272, 14408, 9304, 13384, 9320, 11336, 9336, 15432,
    9368, 12872, 9384, 10824, 9400, 14920, 9416, 9800, 9432, 13896, 9448, 11848, 9464, 15944, 9496, 12616,
    9512, 10568, 9528, 14664, 9560, 13640, 9576, 11592, 9592, 15688, 9624, 13128, 9640, 11080, 9656, 15176,
    9672, 10056, 9688, 14152, 9704, 12104, 9720, 16200, 9752, 12488, 9768, 10440, 9784, 14536, 9816, 13512,
    9832, 11464, 9848, 15560, 9880, 13000, 9896, 10952, 9912, 15048, 9944, 14024, 9960, 11976, 9976, 16072,
    10008, 12744, 10024, 10696, 10040, 14792, 10072, 13768, 10088, 11720, 10104, 15816, 10136, 13256, 10152, 11208,
    10168, 15304, 10200, 14280, 10216, 12232, 10232, 16328, 10264, 12328, 10296, 14376, 10328, 13352, 10344, 11304,
    10360, 15400, 10392, 12840, 10408, 10792, 10424, 14888, 10456, 13864, 10472, 11816, 10488, 15912, 10520, 12584,
    10552, 14632, 10584, 13608, 10600, 11560, 10616, 15656, 10648, 13096, 10664, 11048, 10680, 15144, 10712, 14120,
    10728, 12072, 10744, 16168, 10776, 12456, 10808, 14504, 10840, 13480, 10856, 11432, 10872, 15528, 10904, 12968,
    10936, 15016, 10968, 13992, 10984, 11944, 11000, 16040, 11032, 12712, 11064, 14760, 11096, 13736, 11112, 11688,
    11128, 15784, 11160, 13224, 11192, 15272, 11224, 14248, 11240, 12200, 11256, 16296, 11288, 12392, 11320, 14440,
    11352, 13416, 11384, 15464, 11416, 12904, 11448, 14952, 11480, 13928, 11496, 11880, 11512, 15976, 11544, 12648,
    11576, 14696, 11608, 13672, 11640, 15720, 11672, 13160, 11704, 15208, 11736, 14184, 11752, 12136, 11768, 16232,
    11800, 12520, 11832, 14568, 11864, 13544, 11896, 15592, 11928, 13032, 11960, 15080, 11992, 14056, 12024, 16104,
    12056, 12776, 12088, 14824, 12120, 13800, 12152, 15848, 12184, 13288, 12216, 15336, 12248, 14312, 12280, 16360,
    12344, 14360, 12376, 13336, 12408, 15384, 12440, 12824, 12472, 14872, 12504, 13848, 12536, 15896, 12600, 14616,
    12632, 13592, 12664, 15640, 12696, 13080, 12728, 15128, 12760, 14104, 12792, 16152, 12856, 14488, 12888, 13464,
    12920, 15512, 12984, 15000, 13016, 13976, 13048, 16024, 13112, 14744, 13144, 13720, 13176, 15768, 13240, 15256,
    13272, 14232, 13304, 16280, 13368, 14424, 13432, 15448, 13496, 14936, 13528, 13912, 13560, 15960, 13624, 14680,
    13688, 15704, 13752, 15192, 13784, 14168, 13816, 16216, 13880, 14552, 13944, 15576, 14008, 15064, 14072, 16088,
    14136, 14808, 14200, 15832, 14264, 15320, 14328, 16344, 14456, 15416, 14520, 14904, 14584, 15928, 14712, 15672,
    14776, 15160, 14840, 16184, 14968, 15544, 15096, 16056, 15224, 15800, 15352, 16312, 15608, 15992, 15864, 16248,
};

const uint16_t bitrev2r_table_4096_fc32[] = {
    8, 16384, 16, 8192, 24, 24576, 32, 4096, 40, 20480, 48, 12288, 56, 28672, 64, 2048,
    72, 18432, 80, 10240, 88, 26624, 96, 6144, 104, 22528, 112, 14336, 120, 30720, 128, 1024,
    136, 17408, 144, 9216, 152, 25600, 160, 5120, 168, 21504, 176, 13312, 184, 29696, 192, 3072,
    200, 19456, 208, 11264, 216, 27648, 224, 7168, 232, 23552, 240, 15360, 248, 31744, 256, 512,
    264, 16896, 272, 8704, 280, 25088, 288, 4608, 296, 20992, 304, 12800, 312, 29184, 320, 2560,
    328, 18944, 336, 10752, 344, 27136, 352, 6656, 360, 23040, 368, 14848, 376, 31232, 384, 1536,
    392, 17920, 400, 9728, 408, 26112, 416, 5632, 424, 22016, 432, 13824, 440, 30208, 448, 3584,
    456, 19968, 464, 11776, 472, 28160, 480, 7680, 488, 24064, 496, 15872, 504, 32256, 520, 16640,
    528, 8448, 536, 24832, 544, 4352, 552, 20736, 560, 12544, 568, 28928, 576, 2304, 584, 18688,
    592, 10496, 600, 26880, 608, 6400, 616, 22784, 624, 14592, 632, 30976, 640, 1280, 648, 17664,
    656, 9472, 664, 25856, 672, 5376, 680, 21760, 688, 13568, 696, 29952, 704, 3328, 712, 19712,
    720, 11520, 728, 27904, 736, 7424, 744, 23808, 752, 15616, 760, 32000, 776, 17152, 784, 8960,
    792, 25344, 800, 4864, 808, 21248, 816, 13056, 824, 29440, 832, 2816, 840, 19200, 848, 11008,
    856, 27392, 864, 6912, 872, 23296, 880, 15104, 888, 31488, 896, 1792, 904, 18176, 912, 9984,
    920, 26368, 928, 5888, 936, 22272, 944, 14080, 952, 30464, 960, 3840, 968, 20224, 976, 12032,
    984, 28416, 992, 7936, 1000, 24320, 1008, 16128, 1016, 32512, 1032, 16512, 1040, 8320, 1048, 24704,
    1056, 4224, 1064, 20608, 1072, 12416, 1080, 28800, 1088, 2176, 1096, 18560, 1104, 10368, 1112, 26752,
    1120, 6272, 1128, 22656, 1136, 14464, 1144, 30848, 1160, 17536, 1168, 9344, 1176, 25728, 1184, 5248,
    1192, 21632, 1200, 13440, 1208, 29824, 1216, 3200, 1224, 19584, 1232, 11392, 1240, 27776, 1248, 7296,
    1256, 23680, 1264, 15488, 1272, 31872, 1288, 17024, 1296, 8832, 1304, 25216, 1312, 4736, 1320, 21120,
    1328, 12928, 1336, 29312, 1344, 2688, 1352, 19072, 1360, 10880, 1368, 27264, 1376, 6784, 1384, 23168,
    1392, 14976, 1400, 31360, 1408, 1664, 1416, 18048, 1424, 9856, 1432, 26240, 1440, 5760, 1448, 22144,
    1456, 13952, 1464, 30336, 1472, 3712, 1480, 20096, 1488, 11904, 1496, 28288, 1504, 7808, 1512, 24192,
    1520, 16000, 1528, 32384, 1544, 16768, 1552, 8576, 1560, 24960, 1568, 4480, 1576, 20864, 1584, 12672,
    1592, 29056, 1600, 2432, 1608, 18816, 1616, 10624, 1624, 27008, 1632, 6528, 1640, 22912, 1648, 14720,
    1656, 31104, 1672, 17792, 1680, 9600, 1688, 25984, 1696, 5504, 1704, 21888, 1712, 13696, 1720, 30080,
    1728, 3456, 1736, 19840, 1744, 11648, 1752, 28032, 1760, 7552, 1768, 23936, 1776, 15744, 1784, 32128,
    1800, 17280, 1808, 9088, 1816, 25472, 1824, 4992, 1832, 21376, 1840, 13184, 1848, 29568, 1856, 2944,
    1864, 19328, 1872, 11136, 1880, 27520, 1888, 7040, 1896, 23424, 1904, 15232, 1912, 31616, 1928, 18304,
    1936, 10112, 1944, 26496, 1952, 6016, 1960, 22400, 1968, 14208, 1976, 30592, 1984, 3968, 1992, 20352,
    2000, 12160, 2008, 28544, 2016, 8064, 2024, 24448, 2032, 16256, 2040, 32640, 2056, 16448, 2064, 8256,
    2072, 24640, 2080, 4160, 2088, 20544, 2096, 12352, 2104, 28736, 2120, 18496, 2128, 10304, 2136, 26688,
    2144, 6208, 2152, 22592, 2160, 14400, 2168, 30784, 2184, 17472, 2192, 9280, 2200, 25664, 2208, 5184,
    2216, 21568, 2224, 13376, 2232, 29760, 2240, 3136, 2248, 19520, 2256, 11328, 2264, 27712, 2272, 7232,
    2280, 23616, 2288, 15424, 2296, 31808, 2312, 16960, 2320, 8768, 2328, 25152, 2336, 4672, 2344, 21056,
    2352, 12864, 2360, 29248, 2368, 2624, 2376, 19008, 2384, 10816, 2392, 27200, 2400, 6720, 2408, 23104,
    2416, 14912, 2424, 31296, 2440, 17984, 2448, 9792, 2456, 26176, 2464, 5696, 2472, 22080, 2480, 13888,
    2488, 30272, 2496, 3648, 2504, 20032, 2512, 11840, 2520, 28224, 2528, 7744, 2536, 24128, 2544, 15936,
    2552, 32320, 2568, 16704, 2576, 8512, 2584, 24896, 2592, 4416, 2600, 20800, 2608, 12608, 2616, 28992,
    2632, 18752, 2640, 10560, 2648, 26944, 2656, 6464, 2664, 22848, 2672, 14656, 2680, 31040, 2696, 17728,
    2704, 9536, 2712, 25920, 2720, 5440, 2728, 21824, 2736, 13632, 2744, 30016, 2752, 3392, 2760, 19776,
    2768, 11584, 2776, 27968, 2784, 7488, 2792, 23872, 2800, 15680, 2808, 32064, 2824, 17216, 2832, 9024,
    2840, 25408, 2848, 4928, 2856, 21312, 2864, 13120, 2872, 29504, 2888, 19264, 2896, 11072, 2904, 27456,
    2912, 6976, 2920, 23360, 2928, 15168, 2936, 31552, 2952, 18240, 2960, 10048, 2968, 26432, 2976, 5952,
    2984, 22336, 2992, 14144, 3000, 30528, 3008, 3904, 3016, 20288, 3024, 12096, 3032, 28480, 3040, 8000,
    3048, 24384, 3056, 16192, 3064, 32576, 3080, 16576, 3088, 8384, 3096, 24768, 3104, 4288, 3112, 20672,
    3120, 12480, 3128, 28864, 3144, 18624, 3152, 10432, 3160, 26816, 3168, 6336, 3176, 22720, 3184, 14528,
    3192, 30912, 3208, 17600, 3216, 9408, 3224, 25792, 3232, 5312, 3240, 21696, 3248, 13504, 3256, 29888,
    3272, 19648, 3280, 11456, 3288, 27840, 3296, 7360, 3304, 23744, 3312, 15552, 3320, 31936, 3336, 17088,
    3344, 8896, 3352, 25280, 3360, 4800, 3368, 21184, 3376, 12992, 3384, 29376, 3400, 19136, 3408, 10944,
    3416, 27328, 3424, 6848, 3432, 23232, 3440, 15040, 3448, 31424, 3464, 18112, 3472, 9920, 3480, 26304,
    3488, 5824, 3496, 22208, 3504, 14016, 3512, 30400, 3520, 3776, 3528, 20160, 3536, 11968, 3544, 28352,
    3552, 7872, 3560, 24256, 3568, 16064, 3576, 32448, 3592, 16832, 3600, 8640, 3608, 25024, 3616, 4544,
    3624, 20928, 3632, 12736, 3640, 29120, 3656, 18880, 3664, 10688, 3672, 27072, 3680, 6592, 3688, 22976,
    3696, 14784, 3704, 31168, 3720, 17856, 3728, 9664, 3736, 26048, 3744, 5568, 3752, 21952, 3760, 13760,
    3768, 30144, 3784, 19904, 3792, 11712, 3800, 28096, 3808, 7616, 3816, 24000, 3824, 15808, 3832, 32192,
    3848, 17344, 3856, 9152, 3864, 25536, 3872, 5056, 3880, 21440, 3888, 13248, 3896, 29632, 3912, 19392,
    3920, 11200, 3928, 27584, 3936, 7104, 3944, 23488, 3952, 15296, 3960, 31680, 3976, 18368, 3984, 10176,
    3992, 26560, 4000, 6080, 4008, 22464, 4016, 14272, 4024, 30656, 4040, 20416, 4048, 12224, 4056, 28608,
    4064, 8128, 4072, 24512, 4080, 16320, 4088, 32704, 4104, 16416, 4112, 8224, 4120, 24608, 4136, 20512,
    4144, 12320, 4152, 28704, 4168, 18464, 4176, 10272, 4184, 26656, 4192, 6176, 4200, 22560, 4208, 14368,
    4216, 30752, 4232, 17440, 4240, 9248, 4248, 25632, 4256, 5152, 4264, 21536, 4272, 13344, 4280, 29728,
    4296, 19488, 4304, 11296, 4312, 27680, 4320, 7200, 4328, 23584, 4336, 15392, 4344, 31776, 4360, 16928,
    4368, 8736, 4376, 25120, 4384, 4640, 4392, 21024, 4400, 12832, 4408, 29216, 4424, 18976, 4432, 10784,
    4440, 27168, 4448, 6688, 4456, 23072, 4464, 14880, 4472, 31264, 4488, 17952, 4496, 9760, 4504, 26144,
    4512, 5664, 4520, 22048, 4528, 13856, 4536, 30240, 4552, 20000, 4560, 11808, 4568, 28192, 4576, 7712,
    4584, 24096, 4592, 15904, 4600, 32288, 4616, 16672, 4624, 8480, 4632, 24864, 4648, 20768, 4656, 12576,
    4664, 28960, 4680, 18720, 4688, 10528, 4696, 26912, 4704, 6432, 4712, 22816, 4720, 14624, 4728, 31008,
    4744, 17696, 4752, 9504, 4760, 25888, 4768, 5408, 4776, 21792, 4784, 13600, 4792, 29984, 4808, 19744,
    4816, 11552, 4824, 27936, 4832, 7456, 4840, 23840, 4848, 15648, 4856, 32032, 4872, 17184, 4880, 8992,
    4888, 25376, 4904, 21280, 4912, 13088, 4920, 29472, 4936, 19232, 4944, 11040, 4952, 27424, 4960, 6944,
    4968, 23328, 4976, 15136, 4984, 31520, 5000, 18208, 5008, 10016, 5016, 26400, 5024, 5920, 5032, 22304,
    5040, 14112, 5048, 30496, 5064, 20256, 5072, 12064, 5080, 28448, 5088, 7968, 5096, 24352, 5104, 16160,
    5112, 32544, 5128, 16544, 5136, 8352, 5144, 24736, 5160, 20640, 5168, 12448, 5176, 28832, 5192, 18592,
    5200, 10400, 5208, 26784, 5216, 6304, 5224, 22688, 5232, 14496, 5240, 30880, 5256, 17568, 5264, 9376,
    5272, 25760, 5288, 21664, 5296, 13472, 5304, 29856, 5320, 19616, 5328, 11424, 5336, 27808, 5344, 7328,
    5352, 23712, 5360, 15520, 5368, 31904, 5384, 17056, 5392, 8864, 5400, 25248, 5416, 21152, 5424, 12960,
    5432, 29344, 5448, 19104, 5456, 10912, 5464, 27296, 5472, 6816, 5480, 23200, 5488, 15008, 5496, 31392,
    5512, 18080, 5520, 9888, 5528, 26272, 5536, 5792, 5544, 22176, 5552, 13984, 5560, 30368, 5576, 20128,
    5584, 11936, 5592, 28320, 5600, 7840, 5608, 24224, 5616, 16032, 5624, 32416, 5640, 16800, 5648, 8608,
    5656, 24992, 5672, 20896, 5680, 12704, 5688, 29088, 5704, 18848, 5712, 10656, 5720, 27040, 5728, 6560,
    5736, 22944, 5744, 14752, 5752, 31136, 5768, 17824, 5776, 9632, 5784, 26016, 5800, 21920, 5808, 13728,
    5816, 30112, 5832, 19872, 5840, 11680, 5848, 28064, 5856, 7584, 5864, 23968, 5872, 15776, 5880, 32160,
    5896, 17312, 5904, 9120, 5912, 25504, 5928, 21408, 5936, 13216, 5944, 29600, 5960, 19360, 5968, 11168,
    5976, 27552, 5984, 7072, 5992, 23456, 6000, 15264, 6008, 31648, 6024, 18336, 6032, 10144, 6040, 26528,
    6056, 22432, 6064, 14240, 6072, 30624, 6088, 20384, 6096, 12192, 6104, 28576, 6112, 8096, 6120, 24480,
    6128, 16288, 6136, 32672, 6152, 16480, 6160, 8288, 6168, 24672, 6184, 20576, 6192, 12384, 6200, 28768,
    6216, 18528, 6224, 10336, 6232, 26720, 6248, 22624, 6256, 14432, 6264, 30816, 6280, 17504, 6288, 9312,
    6296, 25696, 6312, 21600, 6320, 13408, 6328, 29792, 6344, 19552, 6352, 11360, 6360, 27744, 6368, 7264,
    6376, 23648, 6384, 15456, 6392, 31840, 6408, 16992, 6416, 8800, 6424, 25184, 6440, 21088, 6448, 12896,
    6456, 29280, 6472, 19040, 6480, 10848, 6488, 27232, 6496, 6752, 6504, 23136, 6512, 14944, 6520, 31328,
    6536, 18016, 6544, 9824, 6552, 26208, 6568, 22112, 6576, 13920, 6584, 30304, 6600, 20064, 6608, 11872,
    6616, 28256, 6624, 7776, 6632, 24160, 6640, 15968, 6648, 32352, 6664, 16736, 6672, 8544, 6680, 24928,
    6696, 20832, 6704, 12640, 6712, 29024, 6728, 18784, 6736, 10592, 6744, 26976, 6760, 22880, 6768, 14688,
    6776, 31072, 6792, 17760, 6800, 9568, 6808, 25952, 6824, 21856, 6832, 13664, 6840, 30048, 6856, 19808,
    6864, 11616, 6872, 28000, 6880, 7520, 6888, 23904, 6896, 15712, 6904, 32096, 6920, 17248, 6928, 9056,
    6936, 25440, 6952, 21344, 6960, 13152, 6968, 29536, 6984, 19296, 6992, 11104, 7000, 27488, 7016, 23392,
    7024, 15200, 7032, 31584, 7048, 18272, 7056, 10080, 7064, 26464, 7080, 22368, 7088, 14176, 7096, 30560,
    7112, 20320, 7120, 12128, 7128, 28512, 7136, 8032, 7144, 24416, 7152, 16224, 7160, 32608, 7176, 16608,
    7184, 8416, 7192, 24800, 7208, 20704, 7216, 12512, 7224, 28896, 7240, 18656, 7248, 10464, 7256, 26848,
    7272, 22752, 7280, 14560, 7288, 30944, 7304, 17632, 7312, 9440, 7320, 25824, 7336, 21728, 7344, 13536,
    7352, 29920, 7368, 19680, 7376, 11488, 7384, 27872, 7400, 23776, 7408, 15584, 7416, 31968, 7432, 17120,
    7440, 8928, 7448, 25312, 7464, 21216, 7472, 13024, 7480, 29408, 7496, 19168, 7504, 10976, 7512, 27360,
    7528, 23264, 7536, 15072, 7544, 31456, 7560, 18144, 7568, 9952, 7576, 26336, 7592, 22240, 7600, 14048,
    7608, 30432, 7624, 20192, 7632, 12000, 7640, 28384, 7648, 7904, 7656, 24288, 7664, 16096, 7672, 32480,
    7688, 16864, 7696, 8672, 7704, 25056, 7720, 20960, 7728, 12768, 7736, 29152, 7752, 18912, 7760, 10720,
    7768, 27104, 7784, 23008, 7792, 14816, 7800, 31200, 7816, 17888, 7824, 9696, 7832, 26080, 7848, 21984,
    7856, 13792, 7864, 30176, 7880, 19936, 7888, 11744, 7896, 28128, 7912, 24032, 7920, 15840, 7928, 32224,
    7944, 17376, 7952, 9184, 7960, 25568, 7976, 21472, 7984, 13280, 7992, 29664, 8008, 19424, 8016, 11232,
    8024, 27616, 8040, 23520, 8048, 15328, 8056, 31712, 8072, 18400, 8080, 10208, 8088, 26592, 8104, 22496,
    8112, 14304, 8120, 30688, 8136, 20448, 8144, 12256, 8152, 28640, 8168, 24544, 8176, 16352, 8184, 32736,
    8200, 16400, 8216, 24592, 8232, 20496, 8240, 12304, 8248, 28688, 8264, 18448, 8272, 10256, 8280, 26640,
    8296, 22544, 8304, 14352, 8312, 30736, 8328, 17424, 8336, 9232, 8344, 25616, 8360, 21520, 8368, 13328,
    8376, 29712, 8392, 19472, 8400, 11280, 8408, 27664, 8424, 23568, 8432, 15376, 8440, 31760, 8456, 16912,
    8464, 8720, 8472, 25104, 8488, 21008, 8496, 12816, 8504, 29200, 8520, 18960, 8528, 10768, 8536, 27152,
    8552, 23056, 8560, 14864, 8568, 31248, 8584, 17936, 8592, 9744, 8600, 26128, 8616, 22032, 8624, 13840,
    8632, 30224, 8648, 19984, 8656, 11792, 8664, 28176, 8680, 24080, 8688, 15888, 8696, 32272, 8712, 16656,
    8728, 24848, 8744, 20752, 8752, 12560, 8760, 28944, 8776, 18704, 8784, 10512, 8792, 26896, 8808, 22800,
    8816, 14608, 8824, 30992, 8840, 17680, 8848, 9488, 8856, 25872, 8872, 21776, 8880, 13584, 8888, 29968,
    8904, 19728, 8912, 11536, 8920, 27920, 8936, 23824, 8944, 15632, 8952, 32016, 8968, 17168, 8984, 25360,
    9000, 21264, 9008, 13072, 9016, 29456, 9032, 19216, 9040, 11024, 9048, 27408, 9064, 23312, 9072, 15120,
    9080, 31504, 9096, 18192, 9104, 10000, 9112, 26384, 9128, 22288, 9136, 14096, 9144, 30480, 9160, 20240,
    9168, 12048, 9176, 28432, 9192, 24336, 9200, 16144, 9208, 32528, 9224, 16528, 9240, 24720, 9256, 20624,
    9264, 12432, 9272, 28816, 9288, 18576, 9296, 10384, 9304, 26768, 9320, 22672, 9328, 14480, 9336, 30864,
    9352, 17552, 9368, 25744, 9384, 21648, 9392, 13456, 9400, 29840, 9416, 19600, 9424, 11408, 9432, 27792,
    9448, 23696, 9456, 15504, 9464, 31888, 9480, 17040, 9496, 25232, 9512, 21136, 9520, 12944, 9528, 29328,
    9544, 19088, 9552, 10896, 9560, 27280, 9576, 23184, 9584, 14992, 9592, 31376, 9608, 18064, 9616, 9872,
    9624, 26256, 9640, 22160, 9648, 13968, 9656, 30352, 9672, 20112, 9680, 11920, 9688, 28304, 9704, 24208,
    9712, 16016, 9720, 32400, 9736, 16784, 9752, 24976, 9768, 20880, 9776, 12688, 9784, 29072, 9800, 18832,
    9808, 10640, 9816, 27024, 9832, 22928, 9840, 14736, 9848, 31120, 9864, 17808, 9880, 26000, 9896, 21904,
    9904, 13712, 9912, 30096, 9928, 19856, 9936, 11664, 9944, 28048, 9960, 23952, 9968, 15760, 9976, 32144,
    9992, 17296, 10008, 25488, 10024, 21392, 10032, 13200, 10040, 29584, 10056, 19344, 10064, 11152, 10072, 27536,
    10088, 23440, 10096, 15248, 10104, 31632, 10120, 18320, 10136, 26512, 10152, 22416, 10160, 14224, 10168, 30608,
    10184, 20368, 10192, 12176, 10200, 28560, 10216, 24464, 10224, 16272, 10232, 32656, 10248, 16464, 10264, 24656,
    10280, 20560, 10288, 12368, 10296, 28752, 10312, 18512, 10328, 26704, 10344, 22608, 10352, 14416, 10360, 30800,
    10376, 17488, 10392, 25680, 10408, 21584, 10416, 13392, 10424, 29776, 10440, 19536, 10448, 11344, 10456, 27728,
    10472, 23632, 10480, 15440, 10488, 31824, 10504, 16976, 10520, 25168, 10536, 21072, 10544, 12880, 10552, 29264,
    10568, 19024, 10576, 10832, 10584, 27216, 10600, 23120, 10608, 14928, 10616, 31312, 10632, 18000, 10648, 26192,
    10664, 22096, 10672, 13904, 10680, 30288, 10696, 20048, 10704, 11856, 10712, 28240, 10728, 24144, 10736, 15952,
    10744, 32336, 10760, 16720, 10776, 24912, 10792, 20816, 10800, 12624, 10808, 29008, 10824, 18768, 10840, 26960,
    10856, 22864, 10864, 14672, 10872, 31056, 10888, 17744, 10904, 25936, 10920, 21840, 10928, 13648, 10936, 30032,
    10952, 19792, 10960, 11600, 10968, 27984, 10984, 23888, 10992, 15696, 11000, 32080, 11016, 17232, 11032, 25424,
    11048, 21328, 11056, 13136, 11064, 29520, 11080, 19280, 11096, 27472, 11112, 23376, 11120, 15184, 11128, 31568,
    11144, 18256, 11160, 26448, 11176, 22352, 11184, 14160, 11192, 30544, 11208, 20304, 11216, 12112, 11224, 28496,
    11240, 24400, 11248, 16208, 11256, 32592, 11272, 16592, 11288, 24784, 11304, 20688, 11312, 12496, 11320, 28880,
    11336, 18640, 11352, 26832, 11368, 22736, 11376, 14544, 11384, 30928, 11400, 17616, 11416, 25808, 11432, 21712,
    11440, 13520, 11448, 29904, 11464, 19664, 11480, 27856, 11496, 23760, 11504, 15568, 11512, 31952, 11528, 17104,
    11544, 25296, 11560, 21200, 11568, 13008, 11576, 29392, 11592, 19152, 11608, 27344, 11624, 23248, 11632, 15056,
    11640, 31440, 11656, 18128, 11672, 26320, 11688, 22224, 11696, 14032, 11704, 30416, 11720, 20176, 11728, 11984,
    11736, 28368, 11752, 24272, 11760, 16080, 11768, 32464, 11784, 16848, 11800, 25040, 11816, 20944, 11824, 12752,
    11832, 29136, 11848, 18896, 11864, 27088, 11880, 22992, 11888, 14800, 11896, 31184, 11912, 17872, 11928, 26064,
    11944, 21968, 11952, 13776, 11960, 30160, 11976, 19920, 11992, 28112, 12008, 24016, 12016, 15824, 12024, 32208,
    12040, 17360, 12056, 25552, 12072, 21456, 12080, 13264, 12088, 29648, 12104, 19408, 12120, 27600, 12136, 23504,
    12144, 15312, 12152, 31696, 12168, 18384, 12184, 26576, 12200, 22480, 12208, 14288, 12216, 30672, 12232, 20432,
    12248, 28624, 12264, 24528, 12272, 16336, 12280, 32720, 12296, 16432, 12312, 24624, 12328, 20528, 12344, 28720,
    12360, 18480, 12376, 26672, 12392, 22576, 12400, 14384, 12408, 30768, 12424, 17456, 12440, 25648, 12456, 21552,
    12464, 13360, 12472, 29744, 12488, 19504, 12504, 27696, 12520, 23600, 12528, 15408, 12536, 31792, 12552, 16944,
    12568, 25136, 12584, 21040, 12592, 12848, 12600, 29232, 12616, 18992, 12632, 27184, 12648, 23088, 12656, 14896,
    12664, 31280, 12680, 17968, 12696, 26160, 12712, 22064, 12720, 13872, 12728, 30256, 12744, 20016, 12760, 28208,
    12776, 24112, 12784, 15920, 12792, 32304, 12808, 16688, 12824, 24880, 12840, 20784, 12856, 28976, 12872, 18736,
    12888, 26928, 12904, 22832, 12912, 14640, 12920, 31024, 12936, 17712, 12952, 25904, 12968, 21808, 12976, 13616,
    12984, 30000, 13000, 19760, 13016, 27952, 13032, 23856, 13040, 15664, 13048, 32048, 13064, 17200, 13080, 25392,
    13096, 21296, 13112, 29488, 13128, 19248, 13144, 27440, 13160, 23344, 13168, 15152, 13176, 31536, 13192, 18224,
    13208, 26416, 13224, 22320, 13232, 14128, 13240, 30512, 13256, 20272, 13272, 28464, 13288, 24368, 13296, 16176,
    13304, 32560, 13320, 16560, 13336, 24752, 13352, 20656, 13368, 28848, 13384, 18608, 13400, 26800, 13416, 22704,
    13424, 14512, 13432, 30896, 13448, 17584, 13464, 25776, 13480, 21680, 13496, 29872, 13512, 19632, 13528, 27824,
    13544, 23728, 13552, 15536, 13560, 31920, 13576, 17072, 13592, 25264, 13608, 21168, 13624, 29360, 13640, 19120,
    13656, 27312, 13672, 23216, 13680, 15024, 13688, 31408, 13704, 18096, 13720, 26288, 13736, 22192, 13744, 14000,
    13752, 30384, 13768, 20144, 13784, 28336, 13800, 24240, 13808, 16048, 13816, 32432, 13832, 16816, 13848, 25008,
    13864, 20912, 13880, 29104, 13896, 18864, 13912, 27056, 13928, 22960, 13936, 14768, 13944, 31152, 13960, 17840,
    13976, 26032, 13992, 21936, 14008, 30128, 14024, 19888, 14040, 28080, 14056, 23984, 14064, 15792, 14072, 32176,
    14088, 17328, 14104, 25520, 14120, 21424, 14136, 29616, 14152, 19376, 14168, 27568, 14184, 23472, 14192, 15280,
    14200, 31664, 14216, 18352, 14232, 26544, 14248, 22448, 14264, 30640, 14280, 20400, 14296, 28592, 14312, 24496,
    14320, 16304, 14328, 32688, 14344, 16496, 14360, 24688, 14376, 20592, 14392, 28784, 14408, 18544, 14424, 26736,
    14440, 22640, 14456, 30832, 14472, 17520, 14488, 25712, 14504, 21616, 14520, 29808, 14536, 19568, 14552, 27760,
    14568, 23664, 14576, 15472, 14584, 31856, 14600, 17008, 14616, 25200, 14632, 21104, 14648, 29296, 14664, 19056,
    14680, 27248, 14696, 23152, 14704, 14960, 14712, 31344, 14728, 18032, 14744, 26224, 14760, 22128, 14776, 30320,
    14792, 20080, 14808, 28272, 14824, 24176, 14832, 15984, 14840, 32368, 14856, 16752, 14872, 24944, 14888, 20848,
    14904, 29040, 14920, 18800, 14936, 26992, 14952, 22896, 14968, 31088, 14984, 17776, 15000, 25968, 15016, 21872,
    15032, 30064, 15048, 19824, 15064, 28016, 15080, 23920, 15088, 15728, 15096, 32112, 15112, 17264, 15128, 25456,
    15144, 21360, 15160, 29552, 15176, 19312, 15192, 27504, 15208, 23408, 15224, 31600, 15240, 18288, 15256, 26480,
    15272, 22384, 15288, 30576, 15304, 20336, 15320, 28528, 15336, 24432, 15344, 16240, 15352, 32624, 15368, 16624,
    15384, 24816, 15400, 20720, 15416, 28912, 15432, 18672, 15448, 26864, 15464, 22768, 15480, 30960, 15496, 17648,
    15512, 25840, 15528, 21744, 15544, 29936, 15560, 19696, 15576, 27888, 15592, 23792, 15608, 31984, 15624, 17136,
    15640, 25328, 15656, 21232, 15672, 29424, 15688, 19184, 15704, 27376, 15720, 23280, 15736, 31472, 15752, 18160,
    15768, 26352, 15784, 22256, 15800, 30448, 15816, 20208, 15832, 28400, 15848, 24304, 15856, 16112, 15864, 32496,
    15880, 16880, 15896, 25072, 15912, 20976, 15928, 29168, 15944, 18928, 15960, 27120, 15976, 23024, 15992, 31216,
    16008, 17904, 16024, 26096, 16040, 22000, 16056, 30192, 16072, 19952, 16088, 28144, 16104, 24048, 16120, 32240,
    16136, 17392, 16152, 25584, 16168, 21488, 16184, 29680, 16200, 19440, 16216, 27632, 16232, 23536, 16248, 31728,
    16264, 18416, 16280, 26608, 16296, 22512, 16312, 30704, 16328, 20464, 16344, 28656, 16360, 24560, 16376, 32752,
    16408, 24584, 16424, 20488, 16440, 28680, 16456, 18440, 16472, 26632, 16488, 22536, 16504, 30728, 16520, 17416,
    16536, 25608, 16552, 21512, 16568, 29704, 16584, 19464, 16600, 27656, 16616, 23560, 16632, 31752, 16648, 16904,
    16664, 25096, 16680, 21000, 16696, 29192, 16712, 18952, 16728, 27144, 16744, 23048, 16760, 31240, 16776, 17928,
    16792, 26120, 16808, 22024, 16824, 30216, 16840, 19976, 16856, 28168, 16872, 24072, 16888, 32264, 16920, 24840,
    16936, 20744, 16952, 28936, 16968, 18696, 16984, 26888, 17000, 22792, 17016, 30984, 17032, 17672, 17048, 25864,
    17064, 21768, 17080, 29960, 17096, 19720, 17112, 27912, 17128, 23816, 17144, 32008, 17176, 25352, 17192, 21256,
    17208, 29448, 17224, 19208, 17240, 27400, 17256, 23304, 17272, 31496, 17288, 18184, 17304, 26376, 17320, 22280,
    17336, 30472, 17352, 20232, 17368, 28424, 17384, 24328, 17400, 32520, 17432, 24712, 17448, 20616, 17464, 28808,
    17480, 18568, 17496, 26760, 17512, 22664, 17528, 30856, 17560, 25736, 17576, 21640, 17592, 29832, 17608, 19592,
    17624, 27784, 17640, 23688, 17656, 31880, 17688, 25224, 17704, 21128, 17720, 29320, 17736, 19080, 17752, 27272,
    17768, 23176, 17784, 31368, 17800, 18056, 17816, 26248, 17832, 22152, 17848, 30344, 17864, 20104, 17880, 28296,
    17896, 24200, 17912, 32392, 17944, 24968, 17960, 20872, 17976, 29064, 17992, 18824, 18008, 27016, 18024, 22920,
    18040, 31112, 18072, 25992, 18088, 21896, 18104, 30088, 18120, 19848, 18136, 28040, 18152, 23944, 18168, 32136,
    18200, 25480, 18216, 21384, 18232, 29576, 18248, 19336, 18264, 27528, 18280, 23432, 18296, 31624, 18328, 26504,
    18344, 22408, 18360, 30600, 18376, 20360, 18392, 28552, 18408, 24456, 18424, 32648, 18456, 24648, 18472, 20552,
    18488, 28744, 18520, 26696, 18536, 22600, 18552, 30792, 18584, 25672, 18600, 21576, 18616, 29768, 18632, 19528,
    18648, 27720, 18664, 23624, 18680, 31816, 18712, 25160, 18728, 21064, 18744, 29256, 18760, 19016, 18776, 27208,
    18792, 23112, 18808, 31304, 18840, 26184, 18856, 22088, 18872, 30280, 18888, 20040, 18904, 28232, 18920, 24136,
    18936, 32328, 18968, 24904, 18984, 20808, 19000, 29000, 19032, 26952, 19048, 22856, 19064, 31048, 19096, 25928,
    19112, 21832, 19128, 30024, 19144, 19784, 19160, 27976, 19176, 23880, 19192, 32072, 19224, 25416, 19240, 21320,
    19256, 29512, 19288, 27464, 19304, 23368, 19320, 31560, 19352, 26440, 19368, 22344, 19384, 30536, 19400, 20296,
    19416, 28488, 19432, 24392, 19448, 32584, 19480, 24776, 19496, 20680, 19512, 28872, 19544, 26824, 19560, 22728,
    19576, 30920, 19608, 25800, 19624, 21704, 19640, 29896, 19672, 27848, 19688, 23752, 19704, 31944, 19736, 25288,
    19752, 21192, 19768, 29384, 19800, 27336, 19816, 23240, 19832, 31432, 19864, 26312, 19880, 22216, 19896, 30408,
    19912, 20168, 19928, 28360, 19944, 24264, 19960, 32456, 19992, 25032, 20008, 20936, 20024, 29128, 20056, 27080,
    20072, 22984, 20088, 31176, 20120, 26056, 20136, 21960, 20152, 30152, 20184, 28104, 20200, 24008, 20216, 32200,
    20248, 25544, 20264, 21448, 20280, 29640, 20312, 27592, 20328, 23496, 20344, 31688, 20376, 26568, 20392, 22472,
    20408, 30664, 20440, 28616, 20456, 24520, 20472, 32712, 20504, 24616, 20536, 28712, 20568, 26664, 20584, 22568,
    20600, 30760, 20632, 25640, 20648, 21544, 20664, 29736, 20696, 27688, 20712, 23592, 20728, 31784, 20760, 25128,
    20776, 21032, 20792, 29224, 20824, 27176, 20840, 23080, 20856, 31272, 20888, 26152, 20904, 22056, 20920, 30248,
    20952, 28200, 20968, 24104, 20984, 32296, 21016, 24872, 21048, 28968, 21080, 26920, 21096, 22824, 21112, 31016,
    21144, 25896, 21160, 21800, 21176, 29992, 21208, 27944, 21224, 23848, 21240, 32040, 21272, 25384, 21304, 29480,
    21336, 27432, 21352, 23336, 21368, 31528, 21400, 26408, 21416, 22312, 21432, 30504, 21464, 28456, 21480, 24360,
    21496, 32552, 21528, 24744, 21560, 28840, 21592, 26792, 21608, 22696, 21624, 30888, 21656, 25768, 21688, 29864,
    21720, 27816, 21736, 23720, 21752, 31912, 21784, 25256, 21816, 29352, 21848, 27304, 21864, 23208, 21880, 31400,
    21912, 26280, 21928, 22184, 21944, 30376, 21976, 28328, 21992, 24232, 22008, 32424, 22040, 25000, 22072, 29096,
    22104, 27048, 22120, 22952, 22136, 31144, 22168, 26024, 22200, 30120, 22232, 28072, 22248, 23976, 22264, 32168,
    22296, 25512, 22328, 29608, 22360, 27560, 22376, 23464, 22392, 31656, 22424, 26536, 22456, 30632, 22488, 28584,
    22504, 24488, 22520, 32680, 22552, 24680, 22584, 28776, 22616, 26728, 22648, 30824, 22680, 25704, 22712, 29800,
    22744, 27752, 22760, 23656, 22776, 31848, 22808, 25192, 22840, 29288, 22872, 27240, 22888, 23144, 22904, 31336,
    22936, 26216, 22968, 30312, 23000, 28264, 23016, 24168, 23032, 32360, 23064, 24936, 23096, 29032, 23128, 26984,
    23160, 31080, 23192, 25960, 23224, 30056, 23256, 28008, 23272, 23912, 23288, 32104, 23320, 25448, 23352, 29544,
    23384, 27496, 23416, 31592, 23448, 26472, 23480, 30568, 23512, 28520, 23528, 24424, 23544, 32616, 23576, 24808,
    23608, 28904, 23640, 26856, 23672, 30952, 23704, 25832, 23736, 29928, 23768, 27880, 23800, 31976, 23832, 25320,
    23864, 29416, 23896, 27368, 23928, 31464, 23960, 26344, 23992, 30440, 24024, 28392, 24040, 24296, 24056, 32488,
    24088, 25064, 24120, 29160, 24152, 27112, 24184, 31208, 24216, 26088, 24248, 30184, 24280, 28136, 24312, 32232,
    24344, 25576, 24376, 29672, 24408, 27624, 24440, 31720, 24472, 26600, 24504, 30696, 24536, 28648, 24568, 32744,
    24632, 28696, 24664, 26648, 24696, 30744, 24728, 25624, 24760, 29720, 24792, 27672, 24824, 31768, 24856, 25112,
    24888, 29208, 24920, 27160, 24952, 31256, 24984, 26136, 25016, 30232, 25048, 28184, 25080, 32280, 25144, 28952,
    25176, 26904, 25208, 31000, 25240, 25880, 25272, 29976, 25304, 27928, 25336, 32024, 25400, 29464, 25432, 27416,
    25464, 31512, 25496, 26392, 25528, 30488, 25560, 28440, 25592, 32536, 25656, 28824, 25688, 26776, 25720, 30872,
    25784, 29848, 25816, 27800, 25848, 31896, 25912, 29336, 25944, 27288, 25976, 31384, 26008, 26264, 26040, 30360,
    26072, 28312, 26104, 32408, 26168, 29080, 26200, 27032, 26232, 31128, 26296, 30104, 26328, 28056, 26360, 32152,
    26424, 29592, 26456, 27544, 26488, 31640, 26552, 30616, 26584, 28568, 26616, 32664, 26680, 28760, 26744, 30808,
    26808, 29784, 26840, 27736, 26872, 31832, 26936, 29272, 26968, 27224, 27000, 31320, 27064, 30296, 27096, 28248,
    27128, 32344, 27192, 29016, 27256, 31064, 27320, 30040, 27352, 27992, 27384, 32088, 27448, 29528, 27512, 31576,
    27576, 30552, 27608, 28504, 27640, 32600, 27704, 28888, 27768, 30936, 27832, 29912, 27896, 31960, 27960, 29400,
    28024, 31448, 28088, 30424, 28120, 28376, 28152, 32472, 28216, 29144, 28280, 31192, 28344, 30168, 28408, 32216,
    28472, 29656, 28536, 31704, 28600, 30680, 28664, 32728, 28792, 30776, 28856, 29752, 28920, 31800, 28984, 29240,
    29048, 31288, 29112, 30264, 29176, 32312, 29304, 31032, 29368, 30008, 29432, 32056, 29560, 31544, 29624, 30520,
    29688, 32568, 29816, 30904, 29944, 31928, 30072, 31416, 30136, 30392, 30200, 32440, 30328, 31160, 30456, 32184,
    30584, 31672, 30712, 32696, 30968, 31864, 31096, 31352, 31224, 32376, 31480, 32120, 31736, 32632, 32248, 32504,
};

void dsps_fft2r_rev_tables_init_fc32(void)
{
    dsps_fft2r_rev_tables_fc32[0] = (uint16_t *)bitrev2r_table_16_fc32;
    dsps_fft2r_rev_tables_fc32[1] = (uint16_t *)bitrev2r_table_32_fc32;
    dsps_fft2r_rev_tables_fc32[2] = (uint16_t *)bitrev2r_table_64_fc32;
    dsps_fft2r_rev_tables_fc32[3] = (uint16_t *)bitrev2r_table_128_fc32;
    dsps_fft2r_rev_tables_fc32[4] = (uint16_t *)bitrev2r_table_256_fc32;
    dsps_fft2r_rev_tables_fc32[5] = (uint16_t *)bitrev2r_table_512_fc32;
    dsps_fft2r_rev_tables_fc32[6] = (uint16_t *)bitrev2r_table_1024_fc32;
    dsps_fft2r_rev_tables_fc32[7] = (uint16_t *)bitrev2r_table_2048_fc32;
    dsps_fft2r_rev_tables_fc32[8] = (uint16_t *)bitrev2r_table_4096_fc32;

}

uint16_t *dsps_fft2r_rev_tables_fc32[] = {
    (uint16_t *)bitrev2r_table_16_fc32,
    (uint16_t *)bitrev2r_table_32_fc32,
    (uint16_t *)bitrev2r_table_64_fc32,
    (uint16_t *)bitrev2r_table_128_fc32,
    (uint16_t *)bitrev2r_table_256_fc32,
    (uint16_t *)bitrev2r_table_512_fc32,
    (uint16_t *)bitrev2r_table_1024_fc32,
    (uint16_t *)bitrev2r_table_2048_fc32,
    (uint16_t *)bitrev2r_table_4096_fc32,
};

const uint16_t bitrev2r_table_16_fc32_size = 6;
const uint16_t bitrev2r_table_32_fc32_size = 12;
const uint16_t bitrev2r_table_64_fc32_size = 28;
const uint16_t bitrev2r_table_128_fc32_size = 56;
const uint16_t bitrev2r_table_256_fc32_size = 120;
const uint16_t bitrev2r_table_512_fc32_size = 240;
const uint16_t bitrev2r_table_1024_fc32_size = 496;
const uint16_t bitrev2r_table_2048_fc32_size = 992;
const uint16_t bitrev2r_table_4096_fc32_size = 2016;

const uint16_t dsps_fft2r_rev_tables_fc32_size[] = {
    (const uint16_t)6,   // bitrev2r_table_16_fc32_size,
    (const uint16_t)12,  // bitrev2r_table_32_fc32_size,
    (const uint16_t)28,  // bitrev2r_table_64_fc32_size,
    (const uint16_t)56,  // bitrev2r_table_128_fc32_size,
    (const uint16_t)120, // bitrev2r_table_256_fc32_size,
    (const uint16_t)240, // bitrev2r_table_512_fc32_size,
    (const uint16_t)496, // bitrev2r_table_1024_fc32_size,
    (const uint16_t)992, // bitrev2r_table_2048_fc32_size,
    (const uint16_t)2016,// bitrev2r_table_4096_fc32_size,
};
